unit Extend16;

interface

uses
  WinTypes, WinProcs, Messages, SysUtils, Classes;

function ModifySystemIni16(IniFileName, Section, Key, Value: string;
  CaseSensitive: Boolean): Boolean;

implementation

uses CmnFunc2;

function ModifySystemIni16(IniFileName, Section, Key, Value: string;
  CaseSensitive: Boolean): Boolean;
var
  lst: TStringList;
  i, j: Integer;
  sTemp, sFindSect, sFindKey, sFindVal: string;
  bFound: Boolean;
begin
  Result := True;
  lst := TStringList.Create;
  with lst do
  begin
    LoadFromFile(IniFileName);

    sFindSect := '';
    bFound := False;

    for i := 0 to lst.Count - 1 do
    begin
      sTemp := Trim(lst[i]);
      if (Copy(sTemp, 1, 1) = '[')
        and (Copy(sTemp, Length(sTemp), 1) = ']') then
      begin
        {Section}
        if UpperCase(sFindSect) = UpperCase(Section) then
        begin
          j := i;
          while (lst[j - 1] = '') do
            Dec(j);
          lst.Insert(j, Key + '=' + Value);
          Break;
        end;
        sFindSect := Copy(sTemp, 2, Length(sTemp) - 2);
      end
      else if (Copy(sTemp, 1, 1) <> ';') then
        if (Pos('=', sTemp) <> 0) then
        begin
          {Key, Value}
          sFindKey := Trim(Copy(sTemp, 1, Pos('=', sTemp) - 1));
          sFindVal := Trim(Copy(sTemp, Pos('=', sTemp) + 1, Length(sTemp)));
          if (UpperCase(sFindSect) = UpperCase(Section)) then
            if ((CaseSensitive = True)
                  and (UpperCase(sFindKey) = UpperCase(Key))
                  and (sFindVal = Value))
              or ((CaseSensitive = False)
                  and (UpperCase(sFindKey) = UpperCase(Key))
                  and (UpperCase(sFindVal) = UpperCase(Value))) then
            begin
              bFound := True;
              Break;
            end;
        end;
    end;

    if bFound = False then
      if (UpperCase(sFindSect) = UpperCase(Section)) then
        {Add Key, Value}
        lst.Add(Key + '=' + Value)
      else if UpperCase(Section) <> UpperCase(sFindSect) then
      begin
        {Add Section, Key, Value}
        Add('');
        Add('[' + Section + ']');
        Add(Key + '=' + Value);
      end;
      SaveToFile(IniFileName);
  end;
end;

end.
